DEBUG_MODE = False
USE_CUDA = True
CUDA_DEVICE_NUM = 0


##########################################################################################
# Path Config

import os
import sys
import torch

os.chdir(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, "..")  # for problem_def
sys.path.insert(0, "../..")  # for utils

##########################################################################################
import logging

from utils import create_logger
from SMTWTTrainer import PFSPTrainer as Trainer


##########################################################################################
pomo_size = 128

env_params = {
    'job_cnt': 50,
    'pomo_size':pomo_size,
}

model_params = {
    'embedding_dim': 128,
    'sqrt_embedding_dim': 128**(1/2),
    'decoder_layer_num': 5,
    'qkv_dim': 16,
    'sqrt_qkv_dim': 16**(1/2),
    'head_num': 8,
    'ff_hidden_dim': 512,
    'eval_type': 'softmax',
    'latent_cont_size':4,
    'latent_disc_size':12,
    'temperature': 1,
    'pomo_size':pomo_size,
    'eval_pomo_size':pomo_size
}

optimizer_params = {
    'optimizer': {
        'lr': 1*1e-4,
        'weight_decay': 1e-6
    },
    'scheduler': {
        'milestones': [90, 100],
        'gamma': 0.1
    }
}

trainer_params = {
    'use_cuda': USE_CUDA,
    'cuda_device_num': CUDA_DEVICE_NUM,
    'epochs': 100,
    'train_episodes': 1000,
    'train_batch_size': 2,
    'accumulation_step':25,
    'model_load':{
        'enable': False,
        'load_model_only':True,
        'path':'./result/saved_SMTWT50',
        'epoch':100
    }
}

logger_params = {
    'log_file': {
        'desc': 'SMTWT_train',
        'filename': 'run_log'
    }
}
##########################################################################################
# main

def main():
    if DEBUG_MODE:
        _set_debug_mode()

    create_logger(**logger_params)
    _print_config()

    trainer = Trainer(env_params=env_params,
                      model_params=model_params,
                      optimizer_params=optimizer_params,
                      trainer_params=trainer_params)
    trainer.run()


def _set_debug_mode():

    global trainer_params
    trainer_params['epochs'] = 2
    trainer_params['train_episodes'] = 4
    trainer_params['train_batch_size'] = 4
    trainer_params['eval_episode']=4
    trainer_params['eval_batch_size']=4


def _print_config():
    logger = logging.getLogger('root')
    logger.info('DEBUG_MODE: {}'.format(DEBUG_MODE))
    logger.info('USE_CUDA: {}, CUDA_DEVICE_NUM: {}'.format(USE_CUDA, CUDA_DEVICE_NUM))
    [logger.info(g_key + "{}".format(globals()[g_key])) for g_key in globals().keys() if g_key.endswith('params')]


##########################################################################################

if __name__ == "__main__":
    torch.cuda.empty_cache()
    main()